--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Ports
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local changed = false

local function DoOne(p, force)
	local new = force or (not p.available)
	if new ~= p.available then
		p.available = new
		local label = GetString(p.name)
		if p.available then label = "+ "..label
		else label = "- "..label
		end
		SetLabel(p.name, label)
		changed = true
		gSim:QueueMessage("Debug: "..tostring(p.name))
	end
end

local function DoAll()
	for p in LPort:AllPorts() do DoOne(p,true) end
end

local function CloseMenu()
	gSim:FlushMessages()
	if changed then SwapToModal("ui/map.lua")
	else CloseWindow()
	end
end

-------------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-ALL-", command=function() DoAll() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2
	
for port in LPort:AllPorts() do
	local p = port

	local label = GetString(port.name)
	if p.available then label = "#+ "..label
	else label = "#- "..label
	end
	
	table.insert(menu, DevMenuItem { x=0,y=y, w=100, label=label, name=p.name, command=function() DoOne(p) gSim:FlushMessages() end })
	y = y + bsgFontHeight(devfont) + 2
end
	
-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
